<?php

class EWRporta_DataWriter_Pages extends XenForo_DataWriter
{
	protected $_existingDataErrorPhrase = 'requested_page_not_found';

	protected function _getFields()
	{
		return array(
			'EWRporta_pages' => array(
				'page_id'		=> array('type' => self::TYPE_UINT, 'autoIncrement' => true),
				'page_slug'		=> array('type' => self::TYPE_STRING, 'required' => true),
				'page_name'		=> array('type' => self::TYPE_STRING, 'required' => true),
				'page_date'		=> array('type' => self::TYPE_UINT, 'required' => true),
				'page_type'		=> array('type' => self::TYPE_STRING, 'required' => true, 'default' => 'bbcode',
					'allowedValues' => array('bbcode', 'html', 'phpfile')
				),
				'page_content'	=> array('type' => self::TYPE_STRING, 'required' => true),
				'page_parent'	=> array('type' => self::TYPE_UINT, 'required' => true, 'default' => 0),
			)
		);
	}

	protected function _getExistingData($data)
	{
		if (!$pageID = $this->_getExistingPrimaryKey($data))
		{
			return false;
		}

		return array('EWRporta_pages' => $this->getModelFromCache('EWRporta_Model_Pages')->getPageByID($pageID));
	}

	protected function _getUpdateCondition($tableName)
	{
		return 'page_id = ' . $this->_db->quote($this->getExisting('page_id'));
	}

	protected function _preSave()
	{
		$pageslug = $this->get('page_slug');
		$pageslug = strtolower(trim($pageslug));
		$pageslug = preg_replace('/[^a-z0-9\-\s]/', '', $pageslug);
		$pageslug = preg_replace('/\s+/', '-', $pageslug);
		$pageslug = preg_replace('/\-+/', '-', $pageslug);

		$this->set('page_slug', $pageslug);
		$this->set('page_date', time());
	}
}